/**
  * IntegerTextField.java 
  *
  * Version: 
  *	$Id$
  *
  * Revisions:
  *     $Log$
  */

import java.awt.*;
import java.awt.event.*;

/**
  * A GUI component that allows the entry of an integer
  * value.  The component will filter input characters and
  * make sure that only digits are allowed into the input
  * area.
  */

public class IntegerTextField extends TextField implements KeyListener {

    private int size;

    /**
     * A constructor that uses a default size of 0
     *
     */

    public IntegerTextField() {
        super();

        size = 0;
        addKeyListener( this );
    }

    /**
     * A Constructor that allows the user to determine the maxSize
     *
     * @param    maxSize - the maximum number of columns in the field
     *
     */

    public IntegerTextField( int maxSize ) {
        super( maxSize );

        size = maxSize;
        addKeyListener( this );
    }

    // Keylistener stuff to filter characters

    /**
     * Invoked when a key has been pressed.
     *
     * @param event the KeyEvent that occurred
     *
     */

    public void keyPressed( KeyEvent event ) {
        char ch = event.getKeyChar();

        // Make sure that only characters are entered and that no more
        // than size characters are accepted

        if ( Character.isISOControl( ch ) ||
             ( getText().length() < size && Character.isDigit( ch ) ) ) 
	    return;

        event.consume();
    }

    /** 
     * Invoked when a key has been typed. this event occurs when a 
     * key press is followed by a key release.
     *
     * @param event the KeyEvent that occurred
     *
     */

    public void keyTyped( KeyEvent event ) {}

    /**
     * Invoked when a key has been released.
     *
     * @param event the KeyEvent that occurred.
     *
     */

    public void keyReleased( KeyEvent event ) {}

} // IntegerTextField
