/**
 * StopWatch.java
 *
 * Version:
 *	$Id$
 *
 * Revisions:
 *     $Log$
 */

import java.awt.*;
import java.awt.event.*;

/**
 * This program uses the TimeCounter class to create a
 * simple GUI based stop watch.
 */

public class StopWatch implements ActionListener {
    private Frame win;            // Frame for the GUI
    private TimerLabel theTime;   // Where the time will be displayed

    Button lapReset;              // Reset/Lap button
    Button startStop;             // Start/Stop button

    boolean stopped = true;       // Is the stop watch running?
    boolean lap = false;          // Is the stop watch in lap mode?

    /**
     * Create a stop watch.
     *
     * @param    String    Title for the window
     *
     */

    public StopWatch( String id ) {
        win = new Frame( id );

        // Frames do not handle close by default ...

        win.addWindowListener(
                new WindowAdapter() {
                    public void windowClosing( WindowEvent e ) {
                        System.exit( 0 );
                    }
                }
        );

        // Label to display the time

        theTime = new TimerLabel();
        theTime.setFont( new Font("Courier", Font.BOLD, 25 ) );

        // Put the buttons in a separate panel for layout purposes

        Panel buttonPanel = new Panel();

        // Create the labels with their initial labels

        lapReset = new Button( "Reset" );
        lapReset.setActionCommand( "lapReset" );
        lapReset.addActionListener( this );

        startStop = new Button( "Start" );
        startStop.setActionCommand( "startStop" );
        startStop.addActionListener( this );

        buttonPanel.add( lapReset );
        buttonPanel.add( startStop );

        // Build the GUI (time on the top followed by the buttons)

        win.add( "North", theTime );
        win.add( "South", buttonPanel );

        // Start it all up!!

        win.pack();
        win.show();
    }

    /**
     * Handle button press events.
     *
     * @param    event     ActionEvent that occurred
     *
     */

    public void actionPerformed( ActionEvent event ) {
        String cmd = event.getActionCommand();

        // The buttons have dual modes depending on the state of the stop
        // watch.  If the watch is stopped (i.e. not keeping track of
        // time), the startStop button will cause the watch to start (i.e.
        // start counting time).  The other button (lapReset) will reset
        // the watch.
        //
        // If the watch is running, startStop will stop the clock, lapReset
        // place the watch in lap mode (time is being counted but the
        // display is frozen).
    
        if ( stopped ) {
            if (cmd.equals( "startStop" ) ) {
                startTheTimer();
            } else {
                resetTheTimer();
	    }		
        } else if ( cmd.equals( "startStop" ) ) {
            stopTheTimer();
        } else if ( lap ) {
            startTheTimer();
        } else {
            pauseTheTimer();
        }
    }

    /**
     * Start the watch.
     */

    private void startTheTimer() {
        startStop.setLabel( "Stop" );
        lapReset.setLabel( "Lap" );

        stopped = false;
        lap = false;

        theTime.timerStart();
    }

    /**
     * Reset the watch.
     */

    private void resetTheTimer() {
        startStop.setLabel( "Start" );
        lapReset.setLabel( "Reset" );

        stopped = true;
        lap = false;

        theTime.timerReset();
    }

    /**
     * Stop the watch.
     */

    private void stopTheTimer() {
        theTime.timerStop();
        theTime.updateText();

        startStop.setLabel( "Start" );
        lapReset.setLabel( "Reset" );
        stopped = true;
    }

    /**
     * Put the watch in lap mode (freeze the display but
     * continue counting time).
     */

    private void pauseTheTimer() {
        theTime.timerNoUpdate();
        lap = true;
    }

    /**
     * A simple main that will create a watch.
     * 
     * @param args - the command line arguments - ignored
     */

    public static void main( String args[] ) {
        StopWatch gui = new StopWatch( "CS1 Stopwatch" );
    }

} //StopWatch
